// Filename: UnioAPI.C
//
// Description:
//   Unio API source

#include <windows.h>
#include <winioctl.h>
#include "..\unioctl.h"
#include "..\uniodef.h"
#include "unioapi.h"


// constantes
#define BYTE_FLOATING_IO  0xFF
#define WORD_FLOATING_IO  0xFFFF
#define DWORD_FLOATING_IO 0xFFFFFFFF


// global data
HANDLE       hFile;              // device handle
UNIO_PARAMS  UnioParams;         // device parameters
DWORD        count = 0;          // process counter


// DLL entry point
BOOL WINAPI DllEntryPoint( HANDLE hInstDLL, DWORD dwReason, LPVOID Reserved )
{
  BOOL  IoctlResult;
  DWORD IoctlCode;
  DWORD ReturnedLength;

  switch( dwReason ) {
    case DLL_PROCESS_ATTACH:
      if( count == 0 ) {               // first process attached
        // open Unio driver
        hFile = CreateFile(
            "\\\\.\\UnioDev",
            GENERIC_ALL,
            FILE_SHARE_READ | FILE_SHARE_WRITE,
            NULL,
            OPEN_EXISTING,
            0,
            NULL
        );
        if( hFile == INVALID_HANDLE_VALUE )
            return FALSE;

        // get Unio driver parameters
        IoctlCode = (DWORD)IOCTL_UNIO_GET_PARAMETERS;
        IoctlResult = DeviceIoControl(
            hFile,                       // Handle to device
            IoctlCode,                   // IO Control code for Read
            NULL,                        // Buffer to driver
            0,                           // Length of buffer in bytes
            &UnioParams,                 // Buffer from driver
            sizeof( UNIO_PARAMS ),       // Length of buffer in bytes
            &ReturnedLength,             // Bytes placed in DataBuffer
            NULL                         // NULL means wait till op. completes
        );
        if( !IoctlResult ||
            ReturnedLength != sizeof( UNIO_PARAMS ) )
                return FALSE;
      }

      count++;
      break;

    case DLL_PROCESS_DETACH:
      count--;
      if( count == 0 )                   // last process detached
          CloseHandle( hFile );
      break;
  }

  return TRUE;
}


DWORD _export UnioGetAddress( void ) {
  return UnioParams.PortBase;
}


DWORD _export UnioGetCount( void ) {
  return UnioParams.PortCount;
}


BOOL _export UnioByteInput( DWORD Port, PBYTE Buffer ) {
  BOOL  IoctlResult;
  DWORD IoctlCode;
  DWORD DataLength;
  DWORD ReturnedLength;

  IoctlCode  = (DWORD)IOCTL_UNIO_READ_PORT_UCHAR;
  DataLength = sizeof( *Buffer );

  IoctlResult = DeviceIoControl(
      hFile,                        // Handle to device
      IoctlCode,                    // IO Control code for Read
      &Port,                        // Buffer to driver
      sizeof( Port ),               // Length of buffer in bytes
      Buffer,                       // Buffer from driver
      DataLength,                   // Length of buffer in bytes
      &ReturnedLength,              // Bytes placed in DataBuffer
      NULL                          // NULL means wait till op. completes
  );

  if( !IoctlResult || ReturnedLength != DataLength )
      *Buffer = BYTE_FLOATING_IO;

  return IoctlResult;
}

BOOL _export UnioWordInput( DWORD Port, PWORD Buffer ) {
  BOOL  IoctlResult;
  DWORD IoctlCode;
  DWORD DataLength;
  DWORD ReturnedLength;

  IoctlCode  = (DWORD)IOCTL_UNIO_READ_PORT_USHORT;
  DataLength = sizeof( *Buffer );

  IoctlResult = DeviceIoControl(
      hFile,                        // Handle to device
      IoctlCode,                    // IO Control code for Read
      &Port,                        // Buffer to driver
      sizeof( Port ),               // Length of buffer in bytes
      Buffer,                       // Buffer from driver
      DataLength,                   // Length of buffer in bytes
      &ReturnedLength,              // Bytes placed in DataBuffer
      NULL                          // NULL means wait till op. completes
  );

  if( !IoctlResult || ReturnedLength != DataLength )
      *Buffer = WORD_FLOATING_IO;

  return IoctlResult;
}


BOOL _export UnioDWordInput( DWORD Port, PDWORD Buffer ) {
  BOOL  IoctlResult;
  DWORD IoctlCode;
  DWORD DataLength;
  DWORD ReturnedLength;

  IoctlCode  = (DWORD)IOCTL_UNIO_READ_PORT_ULONG;
  DataLength = sizeof( *Buffer );

  IoctlResult = DeviceIoControl(
      hFile,                        // Handle to device
      IoctlCode,                    // IO Control code for Read
      &Port,                        // Buffer to driver
      sizeof( Port ),               // Length of buffer in bytes
      Buffer,                       // Buffer from driver
      DataLength,                   // Length of buffer in bytes
      &ReturnedLength,              // Bytes placed in DataBuffer
      NULL                          // NULL means wait till op. completes
  );

  if( !IoctlResult || ReturnedLength != DataLength )
      *Buffer = DWORD_FLOATING_IO;

  return IoctlResult;
}


BOOL _export UnioByteOutput( DWORD Port, BYTE Data ) {
  BOOL    IoctlResult;
  DWORD   IoctlCode;
  PORT_IO DataBuffer;
  DWORD   DataLength;
  DWORD   ReturnedLength;

  IoctlCode = (DWORD)IOCTL_UNIO_WRITE_PORT_UCHAR;
  DataBuffer.PortNumber = Port;
  DataBuffer.CharData   = Data;
  DataLength = sizeof( DataBuffer.PortNumber ) +
               sizeof( DataBuffer.CharData );

  IoctlResult = DeviceIoControl(
      hFile,                        // Handle to device
      IoctlCode,                    // IO Control code for Read
      &DataBuffer,                  // Buffer to driver
      DataLength,                   // Length of buffer in bytes
      NULL,                         // Buffer from driver
      0,                            // Length of buffer in bytes
      &ReturnedLength,              // Bytes placed in DataBuffer
      NULL                          // NULL means wait till op. completes
  );

  return IoctlResult;
}


BOOL _export UnioWordOutput( DWORD Port, WORD Data ) {
  BOOL    IoctlResult;
  DWORD   IoctlCode;
  PORT_IO DataBuffer;
  DWORD   DataLength;
  DWORD   ReturnedLength;

  IoctlCode = (DWORD)IOCTL_UNIO_WRITE_PORT_USHORT;
  DataBuffer.PortNumber = Port;
  DataBuffer.ShortData  = Data;
  DataLength = sizeof( DataBuffer.PortNumber ) +
               sizeof( DataBuffer.ShortData );

  IoctlResult = DeviceIoControl(
      hFile,                        // Handle to device
      IoctlCode,                    // IO Control code for Read
      &DataBuffer,                  // Buffer to driver
      DataLength,                   // Length of buffer in bytes
      NULL,                         // Buffer from driver
      0,                            // Length of buffer in bytes
      &ReturnedLength,              // Bytes placed in DataBuffer
      NULL                          // NULL means wait till op. completes
  );

  return IoctlResult;
}


BOOL _export UnioDWordOutput( DWORD Port, DWORD Data ) {
  BOOL    IoctlResult;
  DWORD   IoctlCode;
  PORT_IO DataBuffer;
  DWORD   DataLength;
  DWORD   ReturnedLength;

  IoctlCode = (DWORD)IOCTL_UNIO_WRITE_PORT_ULONG;
  DataBuffer.PortNumber = Port;
  DataBuffer.LongData   = Data;
  DataLength = sizeof( DataBuffer.PortNumber ) +
               sizeof( DataBuffer.LongData );

  IoctlResult = DeviceIoControl(
      hFile,                        // Handle to device
      IoctlCode,                    // IO Control code for Read
      &DataBuffer,                  // Buffer to driver
      DataLength,                   // Length of buffer in bytes
      NULL,                         // Buffer from driver
      0,                            // Length of buffer in bytes
      &ReturnedLength,              // Bytes placed in DataBuffer
      NULL                          // NULL means wait till op. completes
  );

  return IoctlResult;
}

